# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 1999,2002 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package SR_cli_column_utils;
#"@(#)04   1.39   src/rsct/registry/cli/pm/SR_cli_column_utils.pm.perl, srcli, rsct_rpyxh, rpyxht1f3 3/12/01 16:41:39"
######################################################################
#                                                                    #
# Package: SR_cli_column_utils.pm                                    #
#                                                                    #
# Description:                                                       #
#   This package contains utility/common subroutines for PERL        #
#   System Registry CLI commands that manipulate column definitions  #
#                                                                    #
# Subroutines Available:                                             #
#   make_col_struct - takes an input array of information and builds #
#       a linked list of column definitions. (NOTE:: This function   #
#       will change significantly when the underlying registry       #
#       data structures are altered.                                 #
#                                                                    #
#   make_sd_defn_array -creates an array of 2 arrays - names and     #
#       data types that correspond to the definition of a pattern of #
#       an sd. Input format is currently expected to be a structure  #
#       such as output from grab_cmdline_data or grab_file_data      #
#                                                                    #
#   make_sd_pattern_array - creates an array of 2 arrays - names and #
#       data types that correspond to the definition of a pattern of #
#       an sd. Input format is currently expected to be a string:    #
#        "{name,data_type},{name,data_type},..."                     #
#                                                                    #
#   grab_cmdline_data - parses command line data holding column      #
#       definition data.                                             #
#                                                                    #
#   grab_file_data - parses input file data holding column definition#
#       data.                                                        #
#                                                                    #
#   Examples:                                                        #
#       ($rc, $column_struct_ptr) = make_col_struct($column_data);   #
#               -OR-                                                 #
#       ($rc, $column_struct_ptr) = make_col_struct($column_data);   #
#                                                                    #
#       ($rc, $column_data) = grab_cmdline_data(@ARGV);              #
#                                                                    #
#       ($rc, $column_data) = grab_file_data($filename, $target_word)#
#                                                                    #
#     The following is not EXPORTed:                                 #
#       ($rc, $sd_pattern_struct) =                                  #
#               make_sd_pattern_array($sd_pattern);                  #
#                                                                    #
#--------------------------------------------------------------------#
#                                                                    #
# Inputs:                                                            #
#   structures from calling programs                                 #
# Outputs:                                                           #
#   stderr - all error messages                                      #
#   stdout - Verbose messages (for debugging)                        #
#                                                                    #
# External References:                                               #
#   Perl Modules:   FileHandle, Carp                                 #
#   SR cli Modules: SR_utils - printCEMsg                            #
#                                                                    #
# Tab Settings:                                                      #
#   4 and tabs should be expanded to spaces before saving this file. #
#   in vi:  (:set ts=4  and   :%!expand -4)                          #
#                                                                    #
# Change Activity:                                                   #
#   000929 HGJ 38317: Initial delivery.                              #
#                                                                    #
######################################################################

use Exporter ();
@ISA = qw(Exporter);
@EXPORT_OK = qw(make_col_struct grab_file_data grab_cmdline_data);


#--------------------------------------------------------------------#
# Included libraries and extensions                                  #
#--------------------------------------------------------------------#
use lib "/usr/sbin/rsct/pm";
use locale;
use FileHandle;

use CT::CT qw(
    CT_SD_PTR
    CT_SD_PTR_ARRAY
    CT_CHAR_PTR
    CT_CHAR_PTR_ARRAY
);
use CT_cli_data_type_utils qw(
    string_to_data_type
);
use CT_cli_input_utils qw(
    convert_input_value
    process_input_file
    process_cmdline_input
);

use CT::SR qw(:sr_qualifier_t);
use SR_cli_rc qw(:return_codes);
use SR_cli_utils qw(
    printCEMsg
    get_table_metadata
    free_table_metadata
    make_value_struct_t
    get_fields_by_index
);


#--------------------------------------------------------------------#
# make_col_struct                                                    #
#   Construct the Perl structure necessary to pass column definition #
#   data to an extension call (sr_create_table or sr_add_columns).   #
#                                                                    #
# Parameters:                                                        #
#  $column_data   an array of column definition metadata,            #
#                 each entry of the form: "key=value"                #
#                                                                    #
# Returns:                                                           #
#  $local_rc     0  if success                                       #
#                   return code for local errors otherwise           #
#  @columns      CT::SR::column_struct_t variable containing the     #
#                column metdata to be passed to an extension.        #
#                                                                    #
# Global Variables:                                                  #
#   $main::Verbose  only used if Verbose mode on.                    #
#   $main::Trace    only used if Trace mode on.                      #
#--------------------------------------------------------------------#
sub make_col_struct
{
my $col_input = shift;

# This hash is specific to creating columns in the registry for the 
# moment. Based on sr_qualifier_t enum in ct_sr_types.h
# TODO: Should this be expanded to support other keywords?
%q_hash = (
    ST => SR_STANDARD,
    st => SR_STANDARD,
    PK => SR_PRIMARY_KEY,
    pk => SR_PRIMARY_KEY,
    SY => SR_SYSTEM,
    sy => SR_SYSTEM,
);    
    
my $is_primary_key = 0;           # used to signal primary key column
my $local_rc = 0;                 # assume a good return code
my $ind = 0;

# Values used for grabbing and parsing data
my $name = "";
my $value = "";
my $key = "";
my $qual = "";
my $prop = "";
my $type = "";
my $data_type = "";
my $default = "";
my $sd_default_value = "";

# Values used for columns with no qualifier, properties or default 
# supplied
my $qual_found = 1;
my $prop_found = 1;
my $def_val_found = 1;
my $temp = "";
@column = ();
my $count = 0;

my $temp_array;
my $element;

$main::Trace && 
    print STDERR "Entered SR_cli_column_utils::make_col_struct\n";

foreach $element (@$col_input) {
    $temp_array = $element->[1];
    $input_temp = shift @$temp_array;
    $key = $input_temp->[0];
    $name = $input_temp->[1];
    

while ($input_temp[0] || @$temp_array) {
    # Assuming data is in order required from command lines,
    # grab each entry and error check.
    if (($key eq "col") || ($key eq "column_name")) {
        # The previous column had no qualifier or default
        if (!$qual_found || !$def_val_found || !$prop_found) { 
            $qual_found = 1;
            $def_val_found = 1;
            $prop_found = 1;
            $name = $input_temp->[1];         # Restore the col name
        }
    }
    else {
        $input_temp = shift @$temp_array;
        $key = $input_temp->[0]; 
        $name = $input_temp->[1];
    }

    # This line is to catch the times the while loop doesn't
    # appear to work. It's not the best, for sure. What can
    # I replace it with, when the loop should work in the first
    # place?
    if (($key eq "") && (!@$temp_array)) { 
        print STDERR "Warning CT_cli_column_utils::make_col_struct entering unexpected code path.\n"; 
        next; 
    }   

    if (($key ne "col") && ($key ne "column_name")) {
        printCEMsg("EMsgSRcliNoColumnName", $name);
        $local_rc = SR_CLI_BAD_OPERAND;
        return $local_rc;
    }

    # Assign the column name to the output array    
    $column[$ind]->{name} = $name;

    # Grab the next piece of data
    $input_temp = shift @$temp_array;
    $key = $input_temp->[0];
    $data_type = $input_temp->[1];

    if (!defined $key || ($key ne "type") && ($key ne "data_type")) {
        printCEMsg("EMsgSRcliNoDataType", $name);
        $local_rc = SR_CLI_BAD_OPERAND;
        return $local_rc;
    }

    # Convert the data type to the appropriate CT data type enum.
    # If the returned value is 0 (CT_UNKNOWN) then the data type passed
    # in was not valid. 
    $type = string_to_data_type($data_type);
    if ($type == 0) {
        $local_rc = SR_CLI_BAD_OPERAND;
        printCEMsg("EMsgSRcliInvalidColumnData", $name);
        return $local_rc;
    }

    # Assign the data type to the output array
    $column[$ind]->{type} = $type;

    # Grab the next piece of data
    $input_temp = shift @$temp_array;
    $key = $input_temp->[0];
    $value = $input_temp->[1];

    if (!defined $key || (($key ne "qual") && ($key ne "qualifier"))) {
        # This is trapping when no qualifier found
        # used to be an error - default is ST.
        $temp = $value; # save this value for next round
        $value = "ST";  
        $qual_found = 0;
    }
    elsif ($value !~ /^(PK|pk|ST|st|SY|sy)$/) {
        # Verify that the qualifier is valid. 
        # If not, report an error and quit
        printCEMsg("EMsgSRcliInvalidColumnData", $name);
        return SR_CLI_BAD_OPERAND;
    }       
    elsif  ($value =~ /^(PK|pk)$/){
        # Set this boolean if the qualifier is a SR_PRIMARY_KEY(PK)
        $is_primary_key = 1; 
    }
    # Assign the qualifier to the output array
    $column[$ind]->{qualifier} = $q_hash{$value};

    # If qualifier found, get next line
    # Otherwise the value in input_temp may be the properties
    if ($qual_found) {
        $input_temp = shift @$temp_array;
        $key = $input_temp->[0];
        $prop = $input_temp->[1];
    }

    # Although the properties attribute is not used on the
    # command line currently, this code is staying in for the future
    # time when it will be used.

    if (!defined $key || (($key ne "prop") && ($key ne "properties"))) {
        # This is trapping when no properties found
        # Default is to set it to 0.
        if ($qual_found) {
            # if a qualifier was found, then the value in $prop
            # needs to be preserved
            $temp =  $prop; 
        }
        $column[$ind]->{properties} = 0;
        $prop_found = 0;
    }

    # If properties were found, get the next line
    if ($prop_found) {
        $qual_found = 1;
        $input_temp = shift @$temp_array;
        $key = $input_temp->[0];
        $default = $input_temp->[1];
    }

    if ($type == CT_SD_PTR or $type == CT_SD_PTR_ARRAY) { 
        if ($key ne "sd_defn") {
            printCEMsg("EMsgSRcliInvalidSDDefn");
            return SR_CLI_USER_ERROR;
        }
    }

    if (defined $key and $key eq "sd_defn") {
        if ($type != CT_SD_PTR and $type != CT_SD_PTR_ARRAY) {
            printCEMsg("EMsgSRcliInvalidSDDefn");
            return SR_CLI_USER_ERROR;
        }

        if ($prop_found) {
            $temp = $default;
        }
        elsif ($qual_found) {
            $temp = $prop;
        }
    
        ($local_rc, $column[$count]->{sd_defn}, $temp_sd_default) = 
                        make_sd_defn_array($temp);

        if ($local_rc != 0) { return $local_rc; }
        if ($type == CT_SD_PTR) {

            $column[$count]->{default} = $temp_sd_default;
        }
        else {
            $column[$count]->{default} = [$temp_sd_default];
        }
            
        # Get the next value for processing.
        $input_temp = shift @$temp_array;
        $key = $input_temp->[0]; 
        $default  = $input_temp->[1];
        $prop_found = 1;
        $qual_found = 1;
            
    }


    if (defined $key && (($key eq "def") || ($key eq "default"))) {
        $def_val_found = 1;

        # if no properties or qualifier found, then
        # default gets assigned over
        if ((!$prop_found) && (!$qual_found)) { 
            $prop_found = 1;
            $qual_found = 1;
            $default = $temp; 
        }
        elsif (!$prop_found) { 
            # In this case, a qualifier was found, but no properties
            # so the value still needs to be reset and the value
            # in $temp assigned to $default
            $prop_found = 1;
            $default = $temp;
        }   

        # Convert the default value from the string to the appropriate
        # Perl structure - set to 0 if is a primary key
        if ($is_primary_key) {
            # Default value ignored for Key columns
            # assign one anyway for completion's sake
            $is_primary_key = 0;
            if (($type == CT_CHAR_PTR) || 
                ($type == CT_CHAR_PTR_ARRAY)) {
                ($local_rc, $column[$count]->{default}) = 
                        convert_input_value($type, "");
            }
            else {
                ($local_rc, $column[$count]->{default}) = 
                        convert_input_value($type, 0);
            }                           
        } else {
            if (($type == CT_SD_PTR) or ($type == CT_SD_PTR_ARRAY)) {
                ($local_rc, $column[$count]->{default}) = 
                        convert_input_value($type, $default, 
                        $column[$count]->{sd_defn}->[1]);

            }
            else {
                ($local_rc, $column[$count]->{default}) = 
                        convert_input_value($type, $default);
            }
        }
        if ($local_rc != 0) {
            return SR_CLI_USER_ERROR;
        }

        # Grab the next value for processing 
        # At this point it could be an sd_definition, or the
        # next column array. an sd_definitions is only expected if
        # a default value was found.

        $input_temp = shift @$temp_array;
        $key = $input_temp->[0]; 
        $name = $input_temp->[1];
            

    } # end if ($key eq "def")...
    else { 
        $def_val_found = 0;
        if (!defined($column[$count]->{default})) { 

            if (($type == CT_CHAR_PTR) || 
                ($type == CT_CHAR_PTR_ARRAY)) {
                ($local_rc, $column[$count]->{default}) = 
                        convert_input_value($type, "", 
                        $column[$count]->{sd_defn}->[1]);
            }
            else {
                ($local_rc, $column[$count]->{default}) = 
                        convert_input_value($type, 0, 
                        $column[$count]->{sd_defn}->[1]);
            }                           

            if ($local_rc != 0) {
                return SR_CLI_USER_ERROR;
            }

        }

        if ($prop_found) {
            $temp = $default;
        }
    }

    # Increment indexes & reset $is_primary_key flag for next iteration
    $ind++;
    $count++;
    $is_primary_key = 0;
    
} # end while 
} # end foreach

$main::Trace && 
    print STDERR "Leaving SR_cli_column_utils::make_col_struct\n";

return ($local_rc, @column);
}   # end make_col_struct


#--------------------------------------------------------------------#
# make_sd_defn_array                                                 #
#   Take sd definition information from input and put it in the      #
#   structure necessary for passing to an extension. An array        #
#   holding two arrays - one of names, one of data types.            #
#   Also builds up a default value to pass back to the calling sub.  #
#   This is an array of hashes - data elements (type and value).     #
#                                                                    #
# Parameters:                                                        #
#   $sd_input - structure containing SD definition to be re done.    #
#                                                                    #
# Returns:                                                           #
#   $local_rc     0  if success                                      #
#                    return code for local errors otherwise          #
#   @sd_output       sd definition structure.                        #
#   @default_values  default value structure.                        #
#                                                                    #
# Global Variables:                                                  #
#   $main::Verbose  only used if Verbose mode on.                    #
#   $main::Trace    only used if Trace mode on.                      #
#--------------------------------------------------------------------#
sub make_sd_defn_array 
{
my $sd_input = shift;

# Set up local variables
my $local_rc = 0;
my @sd_output = ();
my @default_values = ();
my $index = 0;

$main::Trace && 
  print STDERR "Entering SR_cli_column_utils::make_sd_defn_array\n";

foreach $element (@$sd_input) {
    # Used for the default value array of hashes
    my $default;

    # First value should be the name
    if ($element->[1][0][0] eq "name") {
            $sd_output[0][$index] = $element->[1][0][1];
    }
    else { 
        printCEMsg("EMsgSRcliInvalidSDDefn");
        return SR_CLI_USER_ERROR;
    }

    if ($element->[1][1][0] eq "type") {
        $sd_output[1][$index] = 
            string_to_data_type($element->[1][1][1]);
    }
    else {
        printCEMsg("EMsgSRcliInvalidSDDefn");
        return SR_CLI_USER_ERROR;
    }

    if ((defined($element->[1][2][0]) ) 
            && ($element->[1][2][0] =~ /def/)) {
        # Need to have a check here in case not all of the defaults are
        # provided. In this case, is it invalid?

        $default->{type} = $sd_output[1][$index];
        $default->{value} = convert_input_value($sd_output[1][$index], 
                $element->[1][2][1]);
    }
    else { $default->{type} = $sd_output[1][$index];
            $default->{value} = 
                    convert_input_value($sd_output[1][$index],0); 
    }

    $default_values[$index++] = $default; 
    
}

$main::Trace && 
    print STDERR "Leaving SR_cli_column_utils::make_sd_defn_array\n";

return($local_rc, \@sd_output, \@default_values);
}   # end make_sd_defn_array


#--------------------------------------------------------------------#
# make_sd_pattern_array                                              #
#   Take an input array of strings that correspond to data types     #
#   and convert them to an array of arrays of ct_data_type_t enum    #
#   values.                                                          #
#                                                                    #
# Parameters:                                                        #
#  $input_array - array of strings to be converted.                  #
#                                                                    #
# Returns:                                                           #
#  $local_rc - 0 if succes, > 1 otherwise.                           #
#  @sd_patterns  - array of data types.                              #
#                                                                    #
# Global Variables:                                                  #
#--------------------------------------------------------------------#
sub make_sd_pattern_array 
{
my $input_str = shift;
my $local_rc = 0;
my $type;

# Want to pass out an array of sd_definitions. This is an array of
# arrays - one of names, one of data types. This format is being 
# chosen because for converting the SD string to a value, the
# array of SD data types in the pattern has to be passed into
# convert_input_value.
# so: @output_sd_array = ([output_sd_names],[output_sd_data_types]);
# And this is being kept separate from the SD itself, because the
# code to translate ct_value_t sd_ptr values does not contain 
# sd names. 

# What is this going to expect as input?
# "{name,data_type},{name,data_type},{name,data_type}..."

$input_str =~ s/^\[//;
$input_str =~ s/\]$//;
$input_str =~ s/^\{//;
$input_str =~ s/\}$//;

my @sd_output = ();
my @temp = split /\}\,\{/, $input_str;
my $index = 0;
my $entry;
my $name = "";
foreach $entry (@temp) {
    ($name, $type) = split /,/, $entry;
           
    if ($name =~ /^"/ && $name =~ /"\s*$/) {
        $name =~ s/^"//;
        $name =~ s/"\s*$//;
    }
 
    $sd_output[0][$index] = $name;
    $sd_output[1][$index] = string_to_data_type($type);
    $index++;
}

return($local_rc, \@sd_output);
}   # end make_sd_pattern_array


#--------------------------------------------------------------------#
# grab_cmdline_data:                                                 #
#   Takes an array passed to it (assumed to be command line data)    #
#   and parses it such that SD information is pulled out correctly.  #
#   This will require calling                                        #
#   CT_cli_input_utils::process_cmdline_input multiple times.        #
#   Places the sd_defn data inline with the column definitions in    #
#   the array @column_data, for passing out to the calling program   #
#                                                                    #
#   Expected format for SD definition stanza from command line:      #
#   sd_defn='name=bla type=bla def=bla name=bla type=bla def=bla'    #
#   fits into cmdline input:                                         #
#   col=bla type=bla sd_defn='name=bla type=bla def=bla...' def=bla  #
#   and so on and so on and so on.                                   #
#                                                                    #
# Parameters:                                                        #
#   @input_data - input data to be scanned.                          #
#                                                                    #
# Returns:                                                           #
#   $local_rc - 0 if succes, > 1 otherwise.                          #
#   $col_data - reference to structure (array) of command line data. #
#                                                                    #
# Global Variables:                                                  #
#   $main::Trace5 - to set up trace 5 level.                         #
#   $main::Verbose - if verbose mode requested.                      #
#--------------------------------------------------------------------#
sub grab_cmdline_data 
{
use Text::ParseWords;

my (@input_data) = @_;

my $default_found = 1;
my $element_index= 0;
my ($entry, $sd_data, $temp_sd, $col_data);
my $local_rc = 0;

$main::Trace && 
    print STDERR "Entered SR_cli_column_utils::grab_cmdline_data\n";

($local_rc, $col_data) = process_cmdline_input(\@input_data);

# Check for sds in this next batch of column data
foreach $element (@$col_data) {
    $temp_array = $element->[1];
    foreach $entry (@$temp_array) {
        if ($entry->[0] eq "sd_defn") {
            # Put the sd keyword, the element index and the entry
            @entry_words = parse_line(" ", 0, $entry->[1]);
            my @sd_defn = ();
            $default_found = 1; 
            $element_index = 0;
            

            ($local_rc, $sd_data) = 
                        process_cmdline_input(\@entry_words);

            $temp_sd_data = $sd_data->[0][1];   
            while (@$temp_sd_data) {
                $sd_defn[$element_index][0] = 
                        "element $element_index:";

                if ($default_found == 1) {
                    $temp_sd = shift @$temp_sd_data;
                }

                if ($temp_sd->[0] =~ /name/) {
                    $sd_defn[$element_index][1][0] = $temp_sd;
                    $default_found = 0;
                }
                else { 
                    printCEMsg("EMsgSRcliInvalidSDDefn");
                    return SR_CLI_USER_ERROR;
                }

                $temp_sd = shift @$temp_sd_data;
                if ($temp_sd->[0] =~ /type/) {
                    $sd_defn[$element_index][1][1] = $temp_sd;
                }
                else { 
                    printCEMsg("EMsgSRcliInvalidSDDefn"); 
                    return SR_CLI_USER_ERROR;
                }

                $temp_sd = shift @$temp_sd_data;
                if (defined $temp_sd->[0] and 
                    $temp_sd->[0] =~ /def/) {
                    $sd_defn[$element_index][1][2] = $temp_sd;
                    $default_found = 1;
                }
                $element_index++;
                        
            }
            # Need to put this in the 'expected format'
            $entry->[1] = \@sd_defn;
        }
    }
}

$main::Trace && 
    print STDERR "Leaving SR_cli_column_utils::grab_cmdline_data\n";

return($local_rc, $col_data);
}   # end grab_cmdline_data


#--------------------------------------------------------------------#
# grab_file_data:                                                    #
#   Takes an input file, passes over it as many times as it needs to #
#   in order to get all SD information from the file. Uses           #
#   CT_cli_input_utils::process_input_file to read the file.         #
#   Places the sd_defn data inline with the column definitions in    #
#   the array @column_data, for passing out to the calling program   #
#                                                                    #
# Parameters:                                                        #
#   $file_name - input file to be read.                              #
#   $next_target - target to be scanned for in input file            #
#                                                                    #
# Returns:                                                           #
#   $local_rc - 0 if succes, > 1 otherwise.                          #
#   \@column_data - input data in correct structure for CLI use.     #
#                                                                    #
# Global Variables:                                                  #
#   $main::Trace5 - to set up trace 5 level.                         #
#   $main::Verbose - if verbose mode requested.                      #
#--------------------------------------------------------------------#
sub grab_file_data 
{
my ($file_nm, $next_target) = @_;

my ($col_data, $entry, $element);

# @column_data is going to be the parent structure that has
# all the other values tacked onto it.
my @column_data = ();
my $local_rc = 0;
my @temp_sd_array = ();
my @sds_to_check = ($next_target);

$main::Trace && 
    print STDERR "Entered SR_cli_column_utils::grab_file_data\n";

# Scan through the resulting structure to see if any 'sd_defn' 
# keywords are found.
while (scalar(@sds_to_check) > 0) {
    $next_target = shift @sds_to_check;
    $element_index = shift @sds_to_check;
    $entry_index = shift @sds_to_check;

    # This won't put it in order, but what will it do?
    # Call process_input_file at least once
    ($local_rc, $col_data) = 
        process_input_file($file_nm, $next_target);
    ($local_rc == 0) || return($local_rc, \@column_data);

    if (defined($element_index)) {
        # Means this is an SD entry
        # Parse through the @$col_data, looking for /^element \d:$/
        # put each entry onto a temporary array that will be put
        # into @column_data at the indecies given
        # $column_data->[$element_index][1]->[$entry_index][1]
        # if /^column \d+:$/ is found, stop parsing that and push
        # the remainder of the array onto @column_data after scanning
        # it.   


        # Crop off the elements after $element_index and put them on
        # @column_data at the end of the array.
        # Take @$col_data and put it at the appointed spot:
        while (defined $col_data->[0][0] && 
            $col_data->[0][0] =~ /^\s*element \d+/) {
            $element = shift @$col_data;
            push @temp_sd_array, $element;
        }
        
        $column_data[$element_index][1]->[$entry_index][1] = 
            [@temp_sd_array];   
            
        @temp_sd_array = ();

    }
    if (scalar(@{$col_data->[0]}) > 0) { 
        push @column_data, @$col_data; 
    }
    
    # Check for sds in this next batch of column data
    $element_index = 0;
    foreach $element (@$col_data) {
        $entry_index = 0;
        $temp_array = $element->[1];
        foreach $entry (@$temp_array) {
            if ($entry->[0] eq "sd_defn") {
                # Put the sd keyword, the element index and the entry
                push @sds_to_check, $entry->[1], 
                        $element_index, $entry_index;
            }
            $entry_index++;
        }
        $element_index++;
    }

} # end while

$main::Trace && 
    print STDERR "Leaving SR_cli_column_utils::grab_file_data\n";

return($local_rc, \@column_data);

}   # end grab_file_data


#--------------------------------------------------------------------#
# End of file                                                        #
#--------------------------------------------------------------------#
